#include <stdio.h>		/* For printf */
#include "e1432.h"

#define	SIZE	16384

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

int
main(void)
{
    int     i, status, nchan;
    struct e1432_hwconfig hwconfig;
    LONGSIZ32 buffer[SIZE];
    LONGSIZ32 count;
    SHORTSIZ16 laddr = 8;
    SHORTSIZ16 chan_list[32];
    SHORTSIZ16 group;
    E1432ID hw;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    CHECK(e1432_print_errors(1));
    e1432_trace_level(0);
    e1432_debug_level(0);

    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    /* Create channel group */
    CHECK(e1432_get_hwconfig(1, &laddr, &hwconfig));
    nchan = hwconfig.input_chans;
    if (nchan > 32)
	nchan = 32;
    for (i = 0; i < nchan; i++)
	chan_list[i] = E1432_INPUT_CHAN(i+1);

    group = e1432_create_channel_group(hw, nchan, chan_list);
    if (group >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group returned %d\n",
			    group));
	return -1;
    }

    /* Initialize hardware things */
    for (i = 0; i < nchan; i++)
	CHECK(e1432_set_analog_input(hw, chan_list[i],
				     E1432_INPUT_MODE_VOLT,
				     E1432_INPUT_HIGH_NORMAL,
				     E1432_ANTI_ALIAS_ANALOG_ON,
				     E1432_COUPLING_DC, 1.0));
    CHECK(e1432_set_data_size(hw, group, E1432_DATA_SIZE_32_SERV));
    CHECK(e1432_set_blocksize(hw, group, SIZE));
    CHECK(e1432_set_span(hw, group, 10000.0));

    /* Start measurement */
    CHECK(e1432_init_measure(hw, group));

    for ( ; ; )
    {
	/* Wait for block available */
	while ((status = e1432_block_available(hw, group)) == 0);
	if (status > 0)
	    (void) printf("Block available found!\n");
	else
	{
	    DEBUG((void) printf("Error %d from e1432_block_available\n",
				status));
	    return -1;
	}

	/* Read some data */
	for (i = 0; i < nchan; i++)
	{
	    CHECK(e1432_read_raw_data(hw, chan_list[i],
				      E1432_TIME_DATA, buffer,
				      SIZE, NULL, &count));
	    if (count != SIZE)
	    {
		DEBUG((void) printf("Actual count was %d\n", count));
		return -1;
	    }

	    (void) printf("First four data samples: "
			  "0x%8.8x, 0x%8.8x, 0x%8.8x, 0x%8.8x\n",
			  *buffer, *(buffer + 1),
			  *(buffer + 2), *(buffer + 3));
	}
    }
    /*NOTREACHED*/
    return 0;
}
